 ; Ŀ
 ;   Sarve - save a drawing to a rev suffixed name.                        
 ;   Copyright 2009 by Rocket Software Ltd.                                
 ;                                                                         
 ; 

 ; Ŀ
 ;   Batten - Add to a pdf copy and rename batch file.                     
 ;   Arguments: Oldnam, the existing pdf name.                             
 ;              Newnam, the desired pdf name.                              
 ;              Newdir, the destination directory name.                    
 ;   Calls nothing, returns nothing, is completely insane.                 
 ; 
 (DEFUN BATTEN (oldnam newnam newdir / fn linn)
 ; Ŀ
 ;   Write the batch file.                                                 
 ; 
  (setq fn (open "c:\\Pdfnam.bat" "a"))
  (setq linn (strcat "ren " oldnam ".pdf " newnam ".pdf"))
  (write-line linn fn)
  (setq linn (strcat "copy \"" newnam ".pdf\" \"" newdir newnam ".pdf\""))
  (write-line linn fn)
  (if fn (close fn))
 (princ))
 ; Ŀ
 ;   Batten end.                                                           
 ; 
 
 ; Ŀ
 ;   Noex - returns the drawing name without the extension.                
 ; 
 (DEFUN NOEX ( / dwgnam)
  (setq dwgnam (strcase (getvar "dwgname")))
  (if (= (substr dwgnam (- (strlen dwgnam) 3)) ".DWG")
      (setq dwgnam (substr dwgnam 1 (- (strlen dwgnam) 4))))
 dwgnam)
 ; Ŀ
 ;   Noex end.                                                             
 ; 

 ; Ŀ
 ;   Sarve.                                                                
 ; 
 (DEFUN C:SARVE (/ reva dwgnam prefix prefdx pdfrex gnunam)
  (setvar "cmdecho" 0)
 ; Ŀ
 ;   Load Rash, which has the latest rev extraction subroutines.           
 ; 
  (if (null (load "rash" ()))
      (prompt "\n* Can't Load Rash. *"))
 ; Ŀ
 ;   Call Rash to get a rev if there is a known tb in the drawing.         
 ; 
  (if (null (setq reva (rash)))
      (setq reva "AA"))
  (setq dwgnam (noex))
  (setq prefix (getvar "dwgprefix"))
  (setq prefix (substr prefix 90))
  (setq prefdx (strcat "C:\\Red Files\\" prefix))
  (setq pdfrex (strcat "C:\\Red Pdfs\\" prefix))
  (setq gnunam (strcat dwgnam "_R" reva))
  (setq nupref (strcat "\"" prefdx gnunam "\""))
(print nupref)
 ; Ŀ
 ;   Add the line to the pdf copy batch file in C:\                        
 ; 
  (batten dwgnam gnunam pdfrex)
 ; Ŀ
 ;   Apparently Autocad does saveas with the save command.                 
 ;   But for which versions?  Can saveas do this too?                      
 ;   Yes: you need an extra Return to tell it what file format to use.     
 ;   Save saves to the new name but keeps you in the old drawing.          
 ;   Saveas leaves you in the new one.                                     
 ; 
;  (command ".save" gnunam)
  (command ".saveas" "" nupref)
 (princ))